package inc.monsters.mias.data.validation;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.validation.Constraint;
import javax.validation.Payload;
import javax.validation.OverridesAttribute;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.ANNOTATION_TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

@NotNull
@Size(min = 2)

@Constraint(validatedBy = {})
@Retention(RUNTIME)
@Target({METHOD, FIELD, ANNOTATION_TYPE})
public @interface Name {
	
	// The convention is to append message keys with the fully qualified name
	// of the annotation class
    String message() default "{inc.monsters.mias.data.validation.Name.invalid_name}"; 

    // Just pass it on
    Class<?>[] groups() default {};

    // Dito.
    Class<? extends Payload>[] payload() default {};

    // Create an attribute maxLenth that will override the max
    // attribute of the @Size annotation. Set the default of
    // maxLength to 20.
    @OverridesAttribute(constraint = Size.class, name = "max")
    int maxLength() default 20;
}
